const express = require("express");
const cors = require("cors");
const morgan = require("morgan");
const http = require("http");
const app = express();
const fileUpload = require('express-fileupload');
const rateLimit = require('express-rate-limit');
const helmet = require('helmet');
const cron = require("node-cron");
const { cloneRecordCenterline } = require("./middleware/cronJobCenterline");
const { cloneRecordCenterlineItems } = require("./middleware/cronJobCenterlineItems");
const { cloneRecordTimeout } = require("./middleware/cronJobTimeout");
const moment = require('moment-timezone');


const appRouter = require("./routes")

app.use(cors());
app.use(morgan("dev"));
app.use(express.urlencoded({ extended: false }));
app.use(express.json({ extended: false }));
app.use(express.json());
app.use(express.static("public"));
app.use(fileUpload({ safeFileNames: true, preserveExtension: true }));

const limiter = rateLimit({
	windowMs: 5 * 60 * 1000, // 15 minutes
	limit: 50, // Limit each IP to 100 requests per `window` (here, per 15 minutes).
  message: "you have exceed the number of request"
});
// cloneRecordCenterline();

const cronJobSchedule = cron.schedule("*/5 * * * *",async () => {
  console.log("Cron Job Started");
  const karachiTime = moment().tz('Asia/Karachi');
  const dayOfWeek = karachiTime.format('dddd'); 
  // console.log("Day of week: ", dayOfWeek);
  if (dayOfWeek !== "Sunday") {
    // console.log("Today is not Sunday ");
    await cloneRecordCenterline();
    await cloneRecordCenterlineItems();    
    await cloneRecordTimeout();       
  }
  else {
    // console.log("Today is Sunday");
  }
  console.log("Cron Job Completed");
});

// const cronJobScheduleCenterlineItems = cron.schedule("0 * * * *", () => {
//   console.log("Cron Job Started");
//   const karachiTime = moment().tz('Asia/Karachi');
//   const dayOfWeek = karachiTime.format('dddd'); 
//   // console.log("Day of week: ", dayOfWeek);
//   if (dayOfWeek !== "Sunday") {
//     // console.log("Today is not Sunday");
//     cloneRecordCenterline();
//   }
//   else {
//     // console.log("Today is Sunday");
//   }
// });

// const cronJobScheduleTimeout = cron.schedule("0 11 * * *", () => {
//   console.log("Cron Job Started");
//   const karachiTime = moment().tz('Asia/Karachi');
//   const dayOfWeek = karachiTime.format('dddd'); 
//   // console.log("Day of week: ", dayOfWeek);
//   if (dayOfWeek !== "Sunday") {
//     console.log("Today is not Sunday");
//     cloneRecordTimeout();    
//   }
//   else {
//     console.log("Today is Sunday");
//   }
// });

app.use(helmet());

// Apply the rate limiting middleware to all requests.
app.use(limiter);

app.use("/uploads", express.static("uploads"));
app.use("/uploads/images", express.static("uploads/images"));

app.get("/", (req, res) => {
  res.send("Success");
});

app.use("/", appRouter)

// ADD CALL to execute your function(s)
// scheduledFunctions.initScheduledJobs();

const server = http.createServer(app);
const PORT = process.env.PORT || 5000;
server.listen(PORT, () => {
  console.log("Server is running on: localhost:", PORT);
});
