const express = require("express");
const router = express.Router();
const { GlobalDelete } = require("../../GlobalFunctions/GlobalDelete");
const tableName = require("../../Utils/allTableNames");

router.post("/deleteEmailConfiguration", (req, res) => {
  try {
    if (!req.body.id) {
      return res.status(400).send(RESPONSE(false, "Please Provide ID of Record", {}));
    } 
    else {
      let payload = {
        tableName: tableName.emailConfiguration,
        databaseFields: {
          id: req.body.id
        },
      };
      GlobalDelete(payload, res);
    }
  } catch (error) {
    return res.send(RESPONSE(false, "Email Configuration Delete (Catch Error)", {}));
  }
});

module.exports = router;
