const express = require("express");
const router = express.Router();
const bcrypt = require("bcryptjs");
const tableNames = require("../../Utils/allTableNames");
const RESPONSE = require("../../GlobalResponse/RESPONSE");
const pool = require("../../Utils/db");

router.post("/createUser", (req, res) => {
  let email = req.body.email;
  let username = req.body.username;
  let password = req.body.password;
  let department = req.body.department;
  let isAdmin = req.body.isAdmin || "";
  let profileUrl = req.body.profileUrl || "";

  bcrypt.hash(password, 14, function (err, hash) {
    if (err) {
      return res.status(409).send(RESPONSE(false, "Error while hashing", err));
    }
    else {
      pool.getConnection(async (err, connection) => {
        if (err) {
          console.log("eror while creating connection", err);
          return res.send(RESPONSE(false, "database error", {}));
        }
        let payload = {
          tableName: tableNames.users,
          databaseFields: {
            email: email,
            username: username,
            password: hash,
            isAdmin: isAdmin,
            profileUrl: profileUrl,
            department: department,
          },
        };
        connection.query(
          `INSERT INTO ${payload.tableName} SET ?`,
          payload.databaseFields,

          (err, result) => {
            connection.release();

            if (err) {
              if (err.code === "ENOTFOUND") {
                return res
                  .status(404)
                  .send(RESPONSE(false, "Internet Connection Failed", err));
              } else if (err.code === "ER_DUP_ENTRY") {
                return res
                  .status(409)
                  .send(RESPONSE(false, "Duplicate User", err));
              } else {
                return res
                  .status(401)
                  .send(RESPONSE(false, "User creation failed", err));
              }
            } else {
              return res.send(RESPONSE(true, "Succesfully Created", result));
            }
          }
        );
      });
    }
  });
});
module.exports = router;
