const express = require("express");
const router = express.Router();
const { GlobalSelect } = require("../../GlobalFunctions/GlobalSelect");
const tableName = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const reponse = require("../../GlobalResponse/RESPONSE");

router.get("/selectFillCenterline", (req, res) => {
try {
    payload = {
        tableName: tableName.fillCenterline,
    };
    // console.log(payload);
    pool.getConnection((err, connection) => {
    if (err) {
        // console.log("eror while creating connection", err);
        res.send(reponse(false, "database error", {}));
        throw err;
        // return
    }
    connection.query(
        `SELECT * FROM ${payload.tableName} ORDER BY id DESC`,
        (err, result) => {
        connection.release();

        if (err) {
            // console.log(err);
            return res.send(reponse(false, "error while selecting", err));
        } else {
            console.log("Result: ", result);
            // return res.send(reponse(true, "succesfully selected", result));
            const transformedData = transformData(result);
            // console.log(JSON.stringify(transformedData, null, 2));
            // const transformedData = transformData(result);
            // console.log("Transform Data: ", transformedData);
            return res.send(reponse(true, "succesfully selected", transformedData));
        }
        }
    );
    });
} catch (err) {
    return res.send(reponse(false, err.message, err));
}
});

function transformData(dataArray) {
    const grouped = dataArray.reduce((acc, item) => {
        const key = `${item.userId}-${item.userName}-${item.feedbackId}`;

        if (!acc[key]) {
            acc[key] = {
                userId: item.userId,
                userName: item.userName,
                feedbackId: item.feedbackId,
                userCenterlines: []
            };
        }

        acc[key].userCenterlines.push({
            id: item.id,
            centerlineName: item.centerlineName,
            userSubmitValue: item.userSubmitValue,
            // [item.name]: item.value,
            userStatus: item.userStatus
        });

        return acc;
    }, {});

    return Object.values(grouped);
}

// function transformData(dataArray) {
//     // Reduce the array to group by common fields
//     const grouped = dataArray.reduce((acc, item) => {
//         // Create a key for the group
//         const key = `${item.userId}-${item.userName}-${item.centerlineId}`;
        
//         // If the key doesn't exist, initialize it
//         if (!acc[key]) {
//             acc[key] = {
//                 userId: item.userId,
//                 userName: item.userName,
//                 centerlineId: item.centerlineId,
//                 userCenterlines: []
//             };
//         }

//         // Add the specific entry to the userCenterlines array
//         acc[key].userCenterlines.push({
//             id: item.id,
//             [item.name]: item.value,
//             userStatus: item.userStatus
//         });

//         return acc;
//     }, {});

//     // Return the grouped data as a single object (assuming all entries have the same userId, userName, centerlineId)
//     return Object.values(grouped)[0];
// }

module.exports = router;
