const express = require("express");
const router = express.Router();
const { GlobalSelect } = require("../../GlobalFunctions/GlobalSelect");
const response = require("../../GlobalResponse/RESPONSE");
const pool = require("../../Utils/db");
const _ = require('lodash');
const tableName = require("../../Utils/allTableNames");
const moment = require('moment');

router.get("/selectFeedback", (req, res) => {
  payload = {
    tableName: tableName.feedback,
  };
  GlobalSelect(payload, res);
});

router.get("/selectFeedbackWithItems", (req, res) => {

  try {

    const currentDate = moment().format('YYYY-MM-DD');

    console.log("Current Date: ", currentDate);

    payload = {
      tableName: tableName.centerline,
    };
    // console.log("payload >>>>", payload);
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "Database Connection Error", {}));
      }

      //recent query witout timeout fields data

      let query = `Select  f.id, f.centerlineId, f.area, f.machine, f.product, f.equipmentOwnerId, f.equipmentOwner, f.frequency, 
      f.userStatus, f.date as cDate, fi.id as centerlineItemsId, fi.centerlineId, fi.centerlineName,fi.targetValue, fi.minimumValue, 
      fi.maximumValue, fi.units, fi.date from (Select * from feedback where currentlyActive=1 Group BY centerlineId ) as f inner join 
      feedbackItems as fi on f.centerlineId = fi.centerlineId where fi.currentlyActive = 1 and f.currentlyActive = 1`;


      // Complete record will be display
      // let query = `select f.id, f.centerlineId, f.area, f.machine, f.product, f.equipmentOwnerId, f.equipmentOwner, f.frequency, f.userStatus, f.date as cDate, fi.id as centerlineItemsId, fi.centerlineId, fi.centerlineName,
      // fi.targetValue, fi.minimumValue, fi.maximumValue, fi.units, fi.date from feedback as f inner join feedbackItems as fi on f.centerlineId = fi.centerlineId`;

      // Only till today record will be display
      // let query = `select f.centerlineId, f.area, f.machine, f.product, f.frequency, f.userStatus, fi.centerlineId, fi.centerlineName,
      // fi.targetvalue, fi.date, fi.units from feedback as f inner join feedbackItems as fi on f.centerlineId = fi.centerlineId where 
      // fi.date <= ?`;

      connection.query(query, (err, result) => {
          connection.release();

          if (err) {
            // // console.log(err);
            return res.send(response(false, "Error While Selecting", err));
          } else {
            console.log("Result: ", result);  
            const transformedPayload = transformData(result); 
            console.log("Transform Data: ", transformedPayload);
          
            return res.send(response(true, "Succesfully Selected Feedback with Feedback Items", transformedPayload));

          }
        }
      );
    });
  } catch (err) {
    return res.send(response(false, err.message, err));
  }
});

router.get("/selectFeedbackWithFillCenterline", (req, res) => {

  try {
    payload = {
      tableName: tableName.centerline,
    };
    // console.log("payload >>>>", payload);
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "Database Connection Error", {}));
      }
      connection.query(
        //query for centerlineItems which is submitted

        // `select f.id, f.centerlineId, f.area, f.machine, f.product, f.equipmentOwnerId, f.equipmentOwner, f.frequency, f.userStatus,
        // fl.id as fillCenterlineId, fl.userId, fl.userName, fl.feedbackId, fl.centerlineName, fl.userSubmitValue, fl.userStatus, fl.submitDate FROM feedback as f INNER 
        // JOIN fillCenterline as fl on f.id = fl.feedbackId;`,

        //query for centerlineItems which is
          `select f.id, f.centerlineId, f.area, f.machine, f.product, f.equipmentOwnerId, f.equipmentOwner, f.frequency, f.userStatus as feedbackUserStatus, f.currentlyActive, f.date, 
        fl.id as fillCenterlineId, fl.userId, fl.userName, fl.feedbackId,fl.centerlineName, fl.userSubmitValue, fl.userStatus, fl.submitDate FROM (select * from feedback where currentlyActive=0 ) as f Left
        JOIN fillCenterline as fl on f.id = fl.feedbackId;`,

        (err, result) => {
          connection.release();

          if (err) {
            // // console.log(err);
            return res.send(response(false, "Error While Selecting", err));
          } else {
            console.log("Result feedback with fillcenterline: ", result);
            const transformedPayload = transformData1(result); 
            console.log("Transform Data: ", transformedPayload);
          
            return res.send(response(true, "Succesfully Selected Feedback with Feedback Items", transformedPayload));

          }
        }
      );
    });
  } catch (err) {
    return res.send(response(false, err.message, err));
  }
});

const transformData = (data) => {
  const groupedData = _.groupBy(data, 'id');

  return Object.keys(groupedData).map(key => {
      const records = groupedData[key];
      const { id, area, machine, product, equipmentOwner, frequency, userStatus, cDate , currentlyActive } = records[0];

      const centerLineItems = records.map(record => {
          const { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, status, qualityCritical,
            safetyCritical, date, time, dateToUpdate } = record;
          return { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, status, qualityCritical, 
            safetyCritical, date, time, dateToUpdate };
      });

      return {
          id,
          area,
          machine,
          product,
          equipmentOwner,
          frequency,
          userStatus,
          cDate,
          centerLineItems,
          currentlyActive
      };
  });
};

const transformData1 = (data) => {
  const groupedData = _.groupBy(data, 'id');

  return Object.keys(groupedData).map(key => {
      const records = groupedData[key];
      const { id, centerlineId, area, machine, product, equipmentOwnerId, equipmentOwner, frequency, feedbackUserStatus, currentlyActive, date} = records[0];

      const fillCenterlineItems = records.map(record => {
          console.log("RECORD: ", record);
          const { fillCenterlineId, userId, userName, centerlineId, centerlineName, userSubmitValue, userStatus, submitDate } = record;
          return { fillCenterlineId, userId, userName, centerlineId, centerlineName, userSubmitValue, userStatus, submitDate };
      });

      return { id, centerlineId, area, machine, product, equipmentOwnerId, equipmentOwner, frequency, feedbackUserStatus, currentlyActive, date, fillCenterlineItems };
  });
};

module.exports = router;
