var express = require("express");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const router = express.Router();
const tableNames = require("../../Utils/allTableNames");

router.post("/createFeedback", (req, res) => {
  const hostUrl = req.protocol + "://" + req.headers.host;
  let incidentImage;
  if (req.file) {
    incidentImage = hostUrl + "/uploads/images/" + req.file.filename;
  } else {
    incidentImage = "N/A";
  }
  let payload = {
    tableName: tableNames.Categories,
    databaseFields: {
       incidentTitle :req.body.incidentTitle,
       lineName :req.body.lineName,
       irImage :incidentImage,
       icidentStatement:req.body.icidentStatement,
       aidProvider:req.body.aidProvider,
       comment:req.body.comment,
       technologyName:req.body.technologyName,
       incidentName:req.body.incidentName,
       bodyPart:req.body.bodyPart,
       submittedBy:req.body.userName,
       userId:req.body.userId,
       submittedDate:req.body.selectedDate,
       timeStemp:req.body.submittedDate,
    },
  };
 


  GlobalInsert(payload, res);
});

module.exports = router;
