const _ = require('lodash');

const payload = [
    {
        "centerLineId": 1,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 1,
        "centerlineName": "Centerline 1",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Daily",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-05",
        "time": "16:33",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 1,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 2,
        "centerlineName": "Centerline 2",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Daily",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-05",
        "time": "16:37",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 3,
        "area": "Lahore",
        "machine": "M3",
        "product": "Wearing",
        "equipmentOwner": "",
        "centerLineItemsId": 33,
        "centerlineName": "Centerline 10",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Weekly",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-04",
        "time": "13:07",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 3,
        "area": "Lahore",
        "machine": "M3",
        "product": "Wearing",
        "equipmentOwner": "",
        "centerLineItemsId": 34,
        "centerlineName": "Centerline 20",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Weekly",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-04",
        "time": "13:10",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 2,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 38,
        "centerlineName": "Centerline 1",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Monthly",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-03",
        "time": "16:49",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 2,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 39,
        "centerlineName": "Centerline 1",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Monthly",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-06",
        "time": "16:35",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 2,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 40,
        "centerlineName": "Centerline 2",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Daily",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-06",
        "time": "16:37",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 1,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 41,
        "centerlineName": "Centerline 1",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Daily",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-02",
        "time": "16:51",
        "dateToUpdate": ""
    },
    {
        "centerLineId": 1,
        "area": "Karachi",
        "machine": "G3",
        "product": "food",
        "equipmentOwner": "",
        "centerLineItemsId": 42,
        "centerlineName": "Centerline 1",
        "targetValue": 120,
        "minimumValue": 100,
        "maximumValue": 150,
        "units": "10",
        "frequency": "Daily",
        "status": 0,
        "qualityMatter": "",
        "date": "2024-06-06",
        "time": "16:51",
        "dateToUpdate": ""
    }
];

// Function to transform data
const transformData = (data) => {
    const groupedData = _.groupBy(data, 'centerLineId');

    return Object.keys(groupedData).map(key => {
        const records = groupedData[key];
        const { centerLineId, area, machine, product, equipmentOwner } = records[0];

        const centerLineItems = records.map(record => {
            const { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, frequency, status, qualityMatter, date, time, dateToUpdate } = record;
            return { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, frequency, status, qualityMatter, date, time, dateToUpdate };
        });

        return {
            centerLineId,
            area,
            machine,
            product,
            equipmentOwner,
            centerLineItems
        };
    });
};

const transformedPayload = transformData(payload);
console.log(transformedPayload);
// console.log(JSON.stringify({ payload: transformedPayload }, null, 2));
