const express = require("express");
const pool = require("../../Utils/db");
const router = express.Router();
const response = require("../../GlobalResponse/RESPONSE");
const tableName = require("../../Utils/allTableNames");
const tableNames = require("../../Utils/allTableNames");
const { GlobalUpdate } = require('../../GlobalFunctions/GlobalUpdate');
const { GlobalDelete } = require('../../GlobalFunctions/GlobalDelete');
const {
  GlobalSelect,
  GlobalSelectWithWhereClause,
} = require("../../GlobalFunctions/GlobalSelect");
const sendEmail = require('../../middleware/sendMail')



router.get("/selectDepartment", (req, res) => {
  payload = {
    tableName: tableName.Departments,
  };
  GlobalSelect(payload, res);
});
router.get("/selectLine", (req, res) => {
  payload = {
    tableName: tableName.lineNames,
  };
  GlobalSelect(payload, res);
});
router.get("/bodyParts", (req, res) => {
  payload = {
    tableName: tableName.bodyParts,
  };
  GlobalSelect(payload, res);
});
router.get("/incidentTitles", (req, res) => {  
  payload = {
    tableName: tableName.incidentTitles,
  };
  GlobalSelect(payload, res);
});
router.get("/selectProduct", (req, res) => {
  // // console.log("req.body line >>>>>", req.query);
  payload = {
    tableName: tableName.ProductDetails,
    key: "lineName",
    value: req.query.lineName,
    select: "*",
  };
  // // // console.log('payload .....', payload);
  GlobalSelectWithWhereClause(payload, res);
});
router.get("/selectLineAgainstDepartment", (req, res) => {
  // // console.log("req.body liness >>>>>", req.query);
  payload = {
    tableName: tableName.lineNames,
    key: "department",
    value: req.query.department,
    select: "*",
  };
  GlobalSelectWithWhereClause(payload, res);
});
router.get("/selectProductAginstLine", (req, res) => {
  // // console.log("req.body liness >>>>>", req.query);
  payload = {
    tableName: tableName.ProductDetails,
    key: "lineName",
    value: req.query.lineName,
    select: "*",
  };
  GlobalSelectWithWhereClause(payload, res);
});
router.post("/selectLLFeedbackAgainstDepartment", (req, res) => {
  const deptName = req.body.deptName;
  const date = req.body.date;
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND DateSubmission="${date}"`,
        (err, result) => {
          connection.release();
          if (err) {
            // // console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            // // console.log(result);

            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});
router.get("/selectUser", (req, res) => {
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT DISTINCT submittedBy from ${tableNames.LLFeedback}`,
        (err, result) => {
          connection.release();
          if (err) {
            // // console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            // console.log(result);

            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});
router.post("/selectSubmittedUserData", (req, res) => {
  // // console.log("req.body" , req.body);
  // const { deptName, lineName, userName,submittedDate } = req.body;
  const { deptName, lineName, submittedDate, productName,teamName,siteDetails, shiftDetails } = req.body;
  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      let query = productName
        ? `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND lineName="${lineName}" AND productName="${productName}" AND DateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND siteName="${siteDetails}"`
        : `SELECT * from ${tableNames.LLFeedback} where deptName="${deptName}" AND lineName="${lineName}" AND DateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND siteName="${siteDetails}"`;
      connection.query(query, (err, result) => {
        connection.release();
        if (err) {
          // console.log(err);
          return res.send(response(false, "error while selecting", err));
        } else {
          // // console.log("result>>>", result);

          return res.send(response(true, "succesfully selected", result));
        }
      });
    });
  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// // Select LPT data against username
router.post("/selectDepartMeetingUserData", (req, res) => {
  // console.log("req.bodyfrom DepartMeeting" , req.body);
  // const { submittedDate, submittedBy } = req.body;
  const { departName, submittedDate, productName,teamName,siteDetails, shiftDetails } = req.body;

  try {
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      let query = productName
      ? `SELECT * from ${tableNames.departFeedBack} where departName="${departName}" AND   productName="${productName}" AND dateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftDetails="${shiftDetails}" AND siteDetails="${siteDetails}"`
      : `SELECT * from ${tableNames.departFeedBack} where departName="${departName}" AND   dateSubmission="${submittedDate}" AND teamName="${teamName}" AND shiftName="${shiftDetails}" AND shiftDetails="${shiftDetails}"`;
   
      connection.query(query, (err, result) => {
          connection.release();
          if (err) {
            return res.send(response(false, "error while selecting", err));
          } else {
            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// Select Data from Assign Incident Table w.r.t reportIncidentID

router.get("/selectAssignIncident", (req, res) => {
  try {

    // console.log('Req Query: ', req.query);

    const reportIncidentID = req.query.reportIncidentID;

    pool.getConnection((err, connection) => {
      if (err) {
        console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT * from ${tableNames.assignIncident} where reportIncidentID = ${reportIncidentID}`,
        (err, result) => {
          connection.release();
          if (err) {
            console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            console.log(result);
            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    consle.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// Select Data from Assign Incident Table w.r.t Owner ID

router.get("/selectAssignIncidentForUsers", (req, res) => {
  try {

    // console.log('Req Query: ', req.query);
    // console.log('Req Body: ', req.body);

    // const ownerID = req.query.ownerID;
    const ownerID = req.query.ownerID;

    // console.log('req.query.ownerID ', req.query.ownerID);
    // console.log('req.query.ownerID ', req.query.ownerID);

    pool.getConnection((err, connection) => {
      if (err) {
        console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `SELECT * from ${tableNames.assignIncident} where ownerID = ${ownerID}`,
        (err, result) => {
          connection.release();
          if (err) {
            console.log(err);
            return res.send(response(false, "error while selecting", err));
          } else {
            // console.log(result);
            return res.send(response(true, "succesfully selected", result));
          }
        }
      );
    });
  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// Creat new record in Assign Incident and also get data from it

router.post("/createAssignActions", (req, res) => {

  try {
    // console.log("Report Incident ID: ", req.body.reportIncidentID);
    // console.log("Owner ID: ", req.body.ownerID);
    // console.log("Owner: ", req.body.owner);
    // console.log("Owner Email: ", req.body.ownerEmail);
    // console.log("Description: ", req.body.description);
    // console.log("Complete Date: ", req.body.completeDate);

    let payload = {
      tableName: tableName.assignIncident,
      databaseFields: {
        reportIncidentID: req.body.reportIncidentID,
        ownerID: req.body.ownerID,
        owner: req.body.owner,
        ownerEmail: req.body.ownerEmail,
        description: req.body.description,
        completeDate: req.body.completeDate
      },
    };

    pool.getConnection(async (err, connection) => {
      if (err) {
        console.log("eror while creating connection", err);
        return res.send(response(false, "database error", {}));
      }
      connection.query(
        `INSERT INTO ${payload.tableName} SET ?`,
        payload.databaseFields,

        (err, result) => {
          connection.release();

          if (err) {
            // // console.log("database");
            console.log(err);
            return res.send(response(false, "error while inserting", {}));
          } else {
            // // console.log("result");
            // sendEmail(req.body.ownerEmail, req.body.owner, req.body.description, req.body.completeDate, req, res);
            return res.send(response(true, "Sucess", {}));

            // try {

            //   // console.log('Req Query: ', req.query);
          
            //   const reportIncidentID = req.body.reportIncidentID;
          
            //   pool.getConnection((err, connection) => {
            //     if (err) {
            //       console.log("eror while creating connection", err);
            //       return res.send(response(false, "database error", {}));
            //     }
            //     connection.query(
            //       `SELECT * from ${tableNames.assignIncident} where reportIncidentID = ${reportIncidentID}`,
            //       (err, result) => {
            //         connection.release();
            //         if (err) {
            //           console.log(err);
            //           return res.send(response(false, "error while selecting", err));
            //         } else {
            //           console.log(result);
            //           return res.send(response(true, "succesfully selected", result));
            //         }
            //       }
            //     );
            //   });
            // } catch (e) {
            //   consle.log("err from catch", e);
            //   return res.send(response(false, "server error", {}));
            // }

          }
        }
      );
    });
  } catch (err) {
    return res.send(response(false, err.message, err));
  }
});

// Update Assign Incident record

router.post('/updateAssignActions', (req, res) => {
  try {

    // console.log("Report Incident ID: ", req.body.reportIncidentID);
    // console.log("Owner ID: ", req.body.ownerID);
    // console.log("Owner: ", req.body.owner);
    // console.log("Owner Email: ", req.body.ownerEmail);
    // console.log("Description: ", req.body.description);
    // console.log("Complete Date: ", req.body.completeDate);
    // console.log("Short Incident Title: ", req.body.shortIncidentTitle);

    let payload = {
      id: req.body.id,
      tableName: tableName.assignIncident,
      databaseFields: {
        reportIncidentID: req.body.reportIncidentID || "",
        ownerID: req.body.ownerID || "",
        owner: req.body.owner || "",
        ownerEmail: req.body.ownerEmail || "",
        description: req.body.description || "",
        completeDate: req.body.completeDate || "",
        actionStatus: req.body.actionStatus || ""
      },
    };
    
    sendEmail(req.body.ownerEmail, req.body.owner, req.body.description, req.body.completeDate, req.body.shortIncidentTitle, 'update', req, res);

    GlobalUpdate(payload, res);

    // let keys = Object.keys(payload.databaseFields);
    // let values = Object.values(payload.databaseFields);
  
    // pool.getConnection(async (err, connection) => {
    //   if (err) {
    //     // // console.log("eror while creating connection", err);
    //     return res.send(reponse(false, "database error", {}));
    //   }
    //   let query = `UPDATE ${payload.tableName} SET  ${keys.join(
    //     " = ? ,"
    //   )} = ? where id = ${payload.id}`;
    //   //   let params=[keys,values,payload.id]
    //   connection.query(query, values, (err, result) => {
    //     connection.release();

    //     if (err) {
    //       // // console.log(err);
    //       return res.send(reponse(false, "error while updating", err));
    //     } else {
    //       // return res
    //         // .status(200)
    //         // .send(reponse(true, "succesfully updated", result));


    //       // console.log('Req Query: ', req.query);
      
    //       const reportIncidentID = req.body.reportIncidentID;
      
    //       pool.getConnection((err, connection) => {
    //         if (err) {
    //           console.log("eror while creating connection", err);
    //           return res.send(response(false, "database error", {}));
    //         }
    //         connection.query(
    //           `SELECT * from ${tableNames.assignIncident} where reportIncidentID = ${reportIncidentID}`,
    //           (err, result) => {
    //             connection.release();
    //             if (err) {
    //               console.log(err);
    //               return res.send(response(false, "error while selecting", err));
    //             } else {
    //               console.log(result);
    //               return res.send(response(true, "succesfully selected", result));
    //             }
    //           }
    //         );
    //       });           

    //     }
    //   });
    // });

  } catch (e) {
    console.log("err from catch", e);
    return res.send(response(false, "server error", {}));
  }
});

// Delete record from Assign Incident 
router.post("/deleteAssignActions", (req, res) => {
  let payload = {
    tableName: tableNames.assignIncident,
    databaseFields: {
      id: req.body.id,
    },
  };
  GlobalDelete(payload, res);
});

// API for CL, TOTAL FOUND CL, TOP THREE CL END >>>>>>>>>>>>>

module.exports = router;
