const express = require("express");
const router = express.Router();
const { GlobalSelect } = require("../../GlobalFunctions/GlobalSelect");
const tableName = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const response = require("../../GlobalResponse/RESPONSE");
const _ = require('lodash');

router.get("/selectCenterline", (req, res) => {

  payload = {
    tableName: tableName.centerline,
  };
  
  GlobalSelect(payload, res);
});

router.get("/selectCenterlineWithItems", (req, res) => {

  try {
    payload = {
      tableName: tableName.centerline,
    };
    // console.log("payload >>>>", payload);
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "Database Connection Error", {}));
      }
      connection.query(
        `select c.id , c.area, c.machine, c.product, c.equipmentOwner, c.frequency, c.userStatus, ci.id as centerLineItemsId, ci.centerlineName, ci.targetValue, 
        ci.minimumValue, ci.maximumValue, ci.units, ci.status, ci.qualityCritical, ci.safetyCritical, ci.date, ci.time, ci.dateToUpdate FROM 
        centerline as c INNER JOIN centerlineItems as ci on c.id = ci.centerlineId`,
        (err, result) => {
          connection.release();

          if (err) {
            // // console.log(err);
            return res.send(response(false, "Error While Selecting", err));
          } else {
            // console.log("Result: ", result);
            const transformedPayload = transformData(result); 
            // console.log("Transform Data: ", transformedPayload);
          
            return res.send(response(true, "Succesfully Selected Centerline with Centerline Items", transformedPayload));

          }
        }
      );
    });
  } catch (err) {
    return res.send(response(false, err.message, err));
  }
});

// router.get("/selectCenterlineWithItems", (req, res) => {

//   try {
//     payload = {
//       tableName: tableName.centerline,
//     };
//     // console.log("payload >>>>", payload);
//     pool.getConnection((err, connection) => {
//       if (err) {
//         // // console.log("eror while creating connection", err);
//         return res.send(reponse(false, "Database Connection Error", {}));
//       }
//       connection.query(
//         `select c.id , c.area, c.machine, c.product, c.equipmentOwner, c.frequency, c.userStatus, ci.id as centerLineItemsId, ci.centerlineName,
//         ci.targetValue, ci.minimumValue, ci.maximumValue, ci.units, ci.status, ci.qualityCritical, ci.safetyCritical, ci.date, ci.time, 
//         ci.dateToUpdate FROM centerline as c INNER JOIN centerlineItems as ci on c.id = ci.centerlineId UNION select f.id , f.area, f.machine, 
//         f.product, f.equipmentOwner, f.frequency, f.userStatus, fi.id as centerLineItemsId, fi.centerlineName, fi.targetValue, fi.minimumValue, 
//         fi.maximumValue, fi.units, fi.status, fi.qualityCritical, fi.safetyCritical, fi.date, fi.time, fi.dateToUpdate FROM feedback as f 
//         INNER JOIN feedbackItems as fi on f.id = fi.centerlineId`,
//         (err, result) => {
//           connection.release();

//           if (err) {
//             // // console.log(err);
//             return res.send(reponse(false, "Error While Selecting", err));
//           } else {
//             // console.log("Result: ", result);
//             const transformedPayload = transformData(result); 
//             // console.log("Transform Data: ", transformedPayload);
          
//             return res.send(reponse(true, "Succesfully Selected Centerline with Centerline Items", transformedPayload));

//           }
//         }
//       );
//     });
//   } catch (err) {
//     return res.send(reponse(false, err.message, err));
//   }
// });

const transformData = (data) => {
  const groupedData = _.groupBy(data, 'id');

  return Object.keys(groupedData).map(key => {
      const records = groupedData[key];
      const { id, area, machine, product, equipmentOwner, frequency, userStatus } = records[0];

      const centerLineItems = records.map(record => {
          // const { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, frequency, status, qualityCritical,
          //   safetyCritical, date, time, dateToUpdate } = record;
          // return { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, frequency, status, qualityCritical, 
          //   safetyCritical, date, time, dateToUpdate };
          const { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, status, qualityCritical,
            safetyCritical, date, time, dateToUpdate } = record;
          return { centerLineItemsId, centerlineName, targetValue, minimumValue, maximumValue, units, status, qualityCritical, 
            safetyCritical, date, time, dateToUpdate };
      });

      return {
          id,
          area,
          machine,
          product,
          equipmentOwner,
          frequency,
          userStatus,
          centerLineItems
      };
  });
};

module.exports = router;
