const express = require("express");
const router = express.Router();
const { GlobalSelect } = require("../../GlobalFunctions/GlobalSelect");
const tableName = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const response = require("../../GlobalResponse/RESPONSE");
const _ = require('lodash');

router.get("/selectAcknowledgement", (req, res) => {

  payload = {
    tableName: tableName.acknowledgement,
  };
  
  GlobalSelect(payload, res);
});

router.get("/selectAcknowledgementWithItems", (req, res) => {

  try {
    payload = {
      tableName: tableName.acknowledgement,
    };
    // console.log("payload >>>>", payload);
    pool.getConnection((err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(response(false, "Database Connection Error", {}));
      }
      connection.query(
        `SELECT a.id, a.userId, a.userName, ai.id AS id, acknowledgementId, acknowledge, acknowledgeStatus, area, centerlineName, 
        actualValue, creationDate, equipmentOwner, frequency, machine, maximumValue, minimumValue, product, submittedValue, 
        acknowledgedBy, acknowledgedDate, closeBy, closeDate from acknowledgement as a INNER JOIN acknowledgementItems as 
        ai on a.id = ai.acknowledgementId`,
        (err, result) => {
          connection.release();

          if (err) {
            // // console.log(err);
            return res.send(response(false, "Error While Selecting", err));
          } else {
            console.log("Result: ", result);          
            return res.send(response(true, "Succesfully Selected Acknowledgement with Acknowledgement Items", result));
          }
        }
      );
    });
  } catch (err) {
    return res.send(response(false, err.message, err));
  }
});

module.exports = router;
