var express = require("express");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const router = express.Router();
const tableNames = require("../../Utils/allTableNames");
const pool = require("../../Utils/db");
const response = require("../../GlobalResponse/RESPONSE");
const moment = require("moment-timezone");

router.post("/createAcknowledgement", (req, res) => {
  try {
    let payload1 = {
      tableNames: tableNames.acknowledgement,
      databaseFields: {
        userId: req.body.userId,
        userName: req.body.userName
      }
    };
    var acknowledgementId;
    pool.getConnection((error, connection) => {
      if (error) {
        console.log("Error in database connection (Create Acknowledgement): ", error.message);
        return res.send(response(false, "Error in database connection (Create Acknowledgement): ", error.message))
      } else {
        connection.query(`INSERT INTO ${tableNames.acknowledgement} SET ?`, payload1.databaseFields, (error, result) => {
          connection.release();
          if (error) {
            console.log("Error While Inserting (Create Acknowledgement): ", error.message);
            return res.send(response(true, "Error While Inserting (Create Acknowledgement): ", error.message));
          } else {
            console.log("Acknowledgement is Added Successfully");
            acknowledgementId = result["insertId"];
            console.log("Acknowledgement Id: ", acknowledgementId);
            req.body.userSubmittedCenterLines.forEach(item => {
              const { acknowledge, acknowledgeStatus, actualValue, area, centerlineName, creationDate, equipmentOwner, frequency, machine, 
                maximumValue, minimumValue, product, submittedValue } = item;
              let payload2 = {
                tableName: tableNames.acknowledgementItems,
                databaseFields: {
                  acknowledgementId: acknowledgementId,
                  acknowledge: acknowledge,
                  acknowledgeStatus: acknowledgeStatus,
                  actualValue: actualValue,
                  area: area,
                  centerlineName: centerlineName,
                  creationDate: creationDate,
                  equipmentOwner: equipmentOwner,
                  frequency: frequency,
                  machine: machine,
                  maximumValue: maximumValue,
                  minimumValue: minimumValue,
                  product: product,
                  submittedValue: submittedValue
                }
              };
              connection.query(
                `INSERT INTO ${payload2.tableName} SET ?`,
                payload2.databaseFields,
                (error, result) => {
                  connection.release();
                  if (error) {
                    console.log("Error From Acknowledgement Items Tables", error);
                    return res.send(response(false, error.message, {}));
                  } else {
                    console.log("Acknowledgement Items Inserted Successfully");
                  }
                }
              );
            });
            return res.send(response(true, "Items Inserted Successfully", {}));
          }
        });
      }
    });

  } catch (error) {
    console.log("Catch Error: (Create Acknowledgement)", error.message);
    return res.send(response(false, "Catch Error: (Create Acknowledgement)", error.message));
  }
});

module.exports = router;
